UNIT Banana;
INTERFACE
USES
{$L-}
{$U-}
     {$LOAD MQOTP.dumpfile}
       Memtypes, QuickDraw, OSIntf, ToolIntf, PackIntf,
	 {$LOAD Globals.dumpfile}
     {$U Globals.p}  Globals,
	 {$LOAD}
	 {$U Words.p} Words,
	 {$U Edit.p} Edit;
{$U+}
{$SETC DebugFlg:=FALSE}

PROCEDURE DoCommand(mResult: LongInt);
PROCEDURE OpenGame(GameName: Str255; GameRefNum: Integer);

IMPLEMENTATION
{$S Banana}
{********************************************************************************}
PROCEDURE DoAboutSiboot;
VAR
  x:  Integer;
  LoclRect,FrogRect:	 Rect;
  LoclBits:		 ARRAY[1..3100] OF Integer;
  LoclBMap:		 BitMap;
  TempStrng:		 Str255;
  RefCon:		 LongInt;
BEGIN
  SetRect(LoclRect,96,70,416,224);
  LoclBMap.rowBytes:=40;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  SetRect(FrogRect,100,100,412,220);
  SmalWind:=NewWindow(@ERecord,FrogRect,'AboutSiboot',TRUE,AltDBoxProc,
                              POINTER(-1),TRUE,RefCon);
  SetPort(SmalWind);
  TextFace([bold]);
  TempStrng:='Trust and Betrayal: Legacy of Siboot';
  x:=160-(StringWidth(TempStrng) div 2);
  MoveTo(x,20); DrawString(TempStrng);
  TextFace([]);
  TempStrng:='by Chris Crawford';
  x:=160-(StringWidth(TempStrng) div 2);
  MoveTo(x,40); DrawString(TempStrng);
  TempStrng:='Copyright (c) 1987 Chris Crawford';
  x:=160-(StringWidth(TempStrng) div 2);
  MoveTo(x,60); DrawString(TempStrng);
  TempStrng:='All Rights Reserved';
  x:=160-(StringWidth(TempStrng) div 2);
  MoveTo(x,80); DrawString(TempStrng);
  TempStrng:='Version 1.02';
  x:=160-(StringWidth(TempStrng) div 2);
  MoveTo(x,100); DrawString(TempStrng);
  REPEAT SystemTask UNTIL Button;
  CloseWindow(SmalWind);
  CopyBits(LoclBMap,Screenbits,LoclRect,LoclRect,srcCopy,NIL);
  FlushEvents(EveryEvent,0);
END;
{********************************************************************************}
PROCEDURE RecallToday;
VAR
  i,j,x,y:		Integer;
  LoclRect:		Rect;
  LoclBits:		ARRAY[1..10304] OF Integer;
  LoclBMap:		BitMap;
  SaveIndx:		Integer;
  SaveTrans:    ARRAY[1..TransLeng] OF TransRecord;
  SaveRect:		Rect;
  SaveBGFlag:	Boolean;
  NobodyFlag:	Boolean;
  SearchFlag: 	Boolean;
  TempFlg1,TempFlg2,TempFlg3:  Boolean;
  BetrayFlag:	ARRAY[1..ConstChars] OF Boolean;
BEGIN
  SaveBGFlag:=BarGraphFlag;
  BarGraphFlag:=FALSE;
  SaveIndx:=TransIndx;
  TransIndx:=0;
  FOR i:=1 TO TransLeng DO SaveTrans[i]:=TransList[i];
  SaveRect:=OKRect;
  SetRect(OKRect,2,161,62,191);
  SetRect(LoclRect,0,20,512,342);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  FillRect(LoclRect,DiurnalP);
  
  FOR j:=1 TO SntcLeng DO Sentence[0,j]:=0;
  y:=40;
  Sentence[0,SubjectA]:=Player;
  Sentence[0,VerbA]:=WNBetray;
  Sentence[0,ObjectA1]:=WWho;
  PlotSntc(0,80,y,FALSE);
  x:=240;
  NobodyFlag:=TRUE;
  FOR i:=2 TO NumChars DO IF NBetray[Player,i,Day] THEN 
	 BEGIN NobodyFlag:=FALSE; PlotWord(i,x,y); x:=x+40; END;
  IF NobodyFlag THEN PlotWord(WNobody,x,y);
  
  y:=90;
  Sentence[0,SubjectA]:=Player;
  Sentence[0,VerbA]:=WNAttack;
  Sentence[0,ObjectA1]:=WWho;
  PlotSntc(0,80,y,FALSE);
  x:=240;
  NobodyFlag:=TRUE;
  FOR i:=2 TO NumChars DO IF NAttack[Player,i] THEN 
	 BEGIN NobodyFlag:=FALSE; PlotWord(i,x,y); x:=x+40; END;
  IF NobodyFlag THEN PlotWord(WNobody,x,y);
  
  y:=140;
  Sentence[0,SubjectA]:=Player;
  Sentence[0,VerbA]:=WBetray;
  Sentence[0,ObjectA1]:=WWho;
  PlotSntc(0,80,y,FALSE);
  x:=240;
  NobodyFlag:=TRUE;
  FOR j:=1 TO NumChars DO BetrayFlag[j]:=FALSE;
  i:=1;
  WHILE (i<=HistIndx) DO
	BEGIN
	  TempFlg1:=(HstWrd1H^^[i]=Player);
	  TempFlg2:=(HstDateH^^[i]=Day);
	  IF TempFlg1 & TempFlg2 THEN BetrayFlag[HstWrd3H^^[i]]:=TRUE;
	  i:=i+1;
	END;
  FOR i:=2 TO NumChars DO IF BetrayFlag[i] THEN 
	 BEGIN NobodyFlag:=FALSE; PlotWord(i,x,y); x:=x+40; END;
  IF NobodyFlag THEN PlotWord(WNobody,x,y);
  
  y:=190;
  Sentence[0,SubjectA]:=WWho;
  Sentence[0,VerbA]:=WNBetray;
  Sentence[0,ObjectA1]:=Player;
  PlotSntc(0,80,y,FALSE);
  x:=240;
  NobodyFlag:=TRUE;
  FOR i:=2 TO NumChars DO IF NBetray[i,Player,Day] THEN 
	 BEGIN NobodyFlag:=FALSE; PlotWord(i,x,y); x:=x+40; END;
  IF NobodyFlag THEN PlotWord(WNobody,x,y);
  
  y:=240;
  Sentence[0,SubjectA]:=WWho;
  Sentence[0,VerbA]:=WNAttack;
  Sentence[0,ObjectA1]:=Player;
  PlotSntc(0,80,y,FALSE);
  x:=240;
  NobodyFlag:=TRUE;
  FOR i:=2 TO NumChars DO IF NAttack[i,Player] THEN 
	 BEGIN NobodyFlag:=FALSE; PlotWord(i,x,y); x:=x+40; END;
  IF NobodyFlag THEN PlotWord(WNobody,x,y);
  
  y:=290;
  Sentence[0,SubjectA]:=WWho;
  Sentence[0,VerbA]:=WBetray;
  Sentence[0,ObjectA1]:=Player;
  PlotSntc(0,80,y,FALSE);
  x:=240;
  NobodyFlag:=TRUE;
  FOR j:=1 TO NumChars DO BetrayFlag[j]:=FALSE;
  i:=1;
  WHILE (i<=HistIndx) DO
	BEGIN
	  TempFlg1:=(HstWrd3H^^[i]=Player);
	  IF TempFlg1 & HstKnowH[i,Player] THEN BetrayFlag[HstWrd1H^^[i]]:=TRUE;
	  i:=i+1;
	END;
  FOR i:=2 TO NumChars DO IF BetrayFlag[i] THEN 
	 BEGIN NobodyFlag:=FALSE; PlotWord(i,x,y); x:=x+40; END;
  IF NobodyFlag THEN PlotWord(WNobody,x,y);
  
  WaitForOK;
  OKRect:=SaveRect;
  TransIndx:=SaveIndx;
  FOR i:=1 TO TransLeng DO TransList[i]:=SaveTrans[i];
  BarGraphFlag:=SaveBGFlag;
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
END;
{********************************************************************************}
PROCEDURE CharDisp;
CONST
  LeftX = 80;
VAR
  i,j,x,y:		Integer;
  LoclRect:		Rect;
  LoclBits:		ARRAY[1..10304] OF Integer;
  LoclBMap:		BitMap;
  SaveIndx:		Integer;
  SaveTrans:    ARRAY[1..TransLeng] OF TransRecord;
  SaveRect:		Rect;
  SaveBGFlag:	Boolean;
BEGIN
  SaveBGFlag:=BarGraphFlag;
  BarGraphFlag:=FALSE;
  SaveIndx:=TransIndx;
  TransIndx:=0;
  FOR i:=1 TO TransLeng DO SaveTrans[i]:=TransList[i];
  SaveRect:=OKRect;
  SetRect(OKRect,2,161,62,191);
  SetRect(LoclRect,0,20,512,342);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  FillRect(LoclRect,DiurnalP);
  FOR i:=1 TO NumChars DO
    BEGIN
	  x:=LeftX;
	  y:=40*i;
	  PlotWord(i,x,y);
	  x:=x+40;
	  IF CharLocn[i]<0 THEN 
		BEGIN
		  PlotWord(86,x,y);
		  x:=x+32;
		  PlotWord(56-CharLocn[i],x,y);
		END;
	  IF CharLocn[i]>0 THEN PlotWord(CharLocn[i]+56,x,y);
	  IF (CharLocn[i]=0) AND (i<>Player) THEN
	    BEGIN
		  PlotWord(WGo,x,y);
		  x:=x+32;
		  IF Sentence[i,VerbA]=WGo THEN PlotWord(Sentence[i,ObjectA1],x,y);
		END;
	
	  x:=LeftX+132;
	  FOR j:=1 TO 3 DO
		BEGIN
		  x:=x+39;
		  PlotWord(AuraCnt[j,i,Player]+104,x,y);
		  x:=x+32;
		  PlotWord(65+j,x,y);
		END;
	END;
  WaitForOK;
  OKRect:=SaveRect;
  TransIndx:=SaveIndx;
  FOR i:=1 TO TransLeng DO TransList[i]:=SaveTrans[i];
  BarGraphFlag:=SaveBGFlag;
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
END;
{********************************************************************************}
PROCEDURE Dossier(Who: Integer);
CONST
  LeftX = 80;
VAR
  i,j,x,y,z:	Integer;
  LoclRect:		Rect;
  LoclBits:		ARRAY[1..10304] OF Integer;
  LoclBMap:		BitMap;
  SaveIndx:		Integer;
  SaveTrans:    ARRAY[1..TransLeng] OF TransRecord;
  SaveRect:		Rect;
  SaveBGFlag:	Boolean;
  FaceRect:		Rect;
  error,JErr:  	OSErr;
  RefNum:	   	Integer;
  Count:	   	LongInt;
  StoryIn:	   	PACKED ARRAY[0..1023] OF Char;
  TestStr:	   	String[90];
  StartI,EndI: 	Integer;
  LineNum:	   	Integer;
  TempStr:		Str255;
  EndFlag:		Boolean;
  LoveRank:		ARRAY[1..5] OF ARRAY[1..8] OF Integer;
  LoveCount:	ARRAY[1..5] OF Integer;
  LoveStr:		Str255;
BEGIN
  SaveBGFlag:=BarGraphFlag;
  BarGraphFlag:=FALSE;
  SaveIndx:=TransIndx;
  TransIndx:=0;
  FOR i:=1 TO TransLeng DO SaveTrans[i]:=TransList[i];
  SaveRect:=OKRect;
  SetRect(OKRect,2,161,62,191);
  SetRect(LoclRect,0,20,512,342);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  FillRect(LoclRect,white);
  
  LoveStr:='';
  IF (Who>1) & (Who<8) THEN
    BEGIN
	  FOR i:=1 TO 5 DO 
		BEGIN 
		  LoveCount[i]:=0; 
		  FOR j:=1 TO 7 DO LoveRank[i,j]:=0;
		END;
	  FOR j:=1 TO NumChars DO IF j<>Who THEN
		BEGIN
		  x:=Love[Who,j];
		  y:=1;
		  IF x<40 THEN y:=2;
		  IF x<16 THEN y:=3;
		  IF x<-16 THEN y:=4;
		  IF x<-40 THEN y:=5;
		  z:=LoveCount[y]+1; 
		  LoveRank[y,z]:=j; 
		  LoveCount[y]:=z;
		END;
	  FOR i:=1 TO 5 DO IF LoveCount[i]>0 THEN
		BEGIN
		  LoveStr:=Concat(LoveStr,CharName[Who]);
		  CASE i OF
			1: LoveStr:=Concat(LoveStr,' loves ');
			2: LoveStr:=Concat(LoveStr,' likes ');
			3: LoveStr:=Concat(LoveStr,' is neutral about ');
			4: LoveStr:=Concat(LoveStr,' dislikes ');
			5: LoveStr:=Concat(LoveStr,' hates ');
		  END;
		  CASE LoveCount[i] OF
			1: LoveStr:=Concat(LoveStr,CharName[LoveRank[i,1]],'.  ');
			2: LoveStr:=Concat(LoveStr,CharName[LoveRank[i,1]],' and ',CharName[LoveRank[i,2]],'.  ');
		    3,4,5,6:
			  BEGIN
			    FOR j:=1 TO LoveCount[i]-1 DO
			      BEGIN
				    LoveStr:=Concat(LoveStr,CharName[LoveRank[i,j]]);
				    LoveStr:=Concat(LoveStr,', ');
				  END;
				LoveStr:=Concat(LoveStr,'and ',CharName[LoveRank[i,LoveCount[i]]],'.  ');
			  END;
		  END;
		END;
	END;
  
  SetRect(FaceRect,176,28,336,188);
  CopyBits(Face[Who],Screenbits,StdRect3,FaceRect,srcCopy,NIL);
  TextSize(18); TextFont(2);
  MoveTo(256-StringWidth(CharName[Who]) div 2,210);
  DrawString(CharName[Who]);
  TextSize(10); TextFont(1);
  FillChar(StoryIn,1024,' ');
  TempStr:=Concat(':Dossiers:',CharName[Who]);
  error:=FSOpen(TempStr,0,RefNum);
  error:=SetFPos(RefNum,1,0);
  Count:=4096;
  error:=FSRead(RefNum,Count,@StoryIn);
  JErr:=FSClose(RefNum);
  FOR i:=1 TO Length(LoveStr) DO StoryIn[Count+i]:=LoveStr[i];
  Count:=Count+Length(LoveStr);
  LineNum:=1;
  StartI:=0;
  EndFlag:=FALSE;
  REPEAT
	EndI:=StartI+89;
	IF Endi>=Count THEN BEGIN EndFlag:=TRUE; Endi:=Count+1; END;
	REPEAT EndI:=EndI-1 UNTIL StoryIn[EndI]=' ';
	TestStr:='                                                                                          ';
	FOR j:=StartI TO EndI DO TestStr[j-StartI+1]:=StoryIn[j];
	StartI:=EndI+1;
	MoveTo(40,218+14*LineNum);
	DrawString(TestStr);
	LineNum:=LineNum+1;
  UNTIL EndFlag;
  TextFont(0);
  TextSize(12);

  
  WaitForOK;
  OKRect:=SaveRect;
  TransIndx:=SaveIndx;
  FOR i:=1 TO TransLeng DO TransList[i]:=SaveTrans[i];
  BarGraphFlag:=SaveBGFlag;
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
END;
{********************************************************************************}
FUNCTION IOCheck(TheError: OSErr): Boolean;
VAR
  AlertID:		Integer;
  ErrorString:	Str255;
  Ignore:		Integer;
BEGIN
  IOCheck:=TRUE;
  IF TheError=NoErr THEN Exit(IOCheck);
  IOCheck:=FALSE;
  AlertID:=335;
  CASE TheError OF
	WPrErr:		AlertID:=333;
	DskFulErr:	AlertID:=334;
	337: 		AlertID:=337;
	Otherwise
	  BEGIN
		NumToString(TheError,ErrorString);
		ParamText(ErrorString,'','','');
	  END;
  END; {of CASE-statement}
  Ignore:=StopAlert(AlertID,NIL);
END;
{*************************************************************************}
PROCEDURE OpenGame;
VAR
  error:	OSErr;
  y:		LongInt;
  i,x:		Integer;
  JunkFlag:	Boolean;
  NewRect:	Rect;
  NewBMap:	BitMap;
  NewBits:	ARRAY[0..10944] OF Integer;
BEGIN
  SetRect(NewRect,0,0,512,342);
  NewBMap.rowBytes:=64;
  NewBMap.baseAddr:=@NewBits;
  NewBMap.bounds:=NewRect;
  error:=FSOpen(GameName,GameRefNum,StartDummy);
  IF IOCheck(error) THEN
	BEGIN
	  error:=SetFPos(StartDummy,1,0);
	  IF IOCheck(error) THEN
		BEGIN
		  y:=LongInt(@StartDummy)-LongInt(@EndDummy);
		  error:=FSRead(StartDummy,y,@EndDummy);
		  IF IOCheck(error) THEN
			BEGIN
			  DisposHandle(Handle(HstDateH));
			  DisposHandle(Handle(HstTimeH));
			  DisposHandle(Handle(HstWrd1H));
			  DisposHandle(Handle(HstWrd3H));
			  HstDateH:=DatesHndl(NewHandle(2*HistLeng));
			  HstTimeH:=DatesHndl(NewHandle(2*HistLeng));
			  HstWrd1H:=DatesHndl(NewHandle(2*HistLeng));
			  HstWrd3H:=DatesHndl(NewHandle(2*HistLeng));
			  
			  y:=LongInt(2*HistLeng);
			  error:=FSRead(StartDummy,y,@HstWrd1H^^);
			  IF error=0 THEN error:=FSRead(StartDummy,y,@HstWrd3H^^);
			  IF error=0 THEN error:=FSRead(StartDummy,y,@HstDateH^^);
			  IF error=0 THEN error:=FSRead(StartDummy,y,@HstTimeH^^);
			  y:=21888;
			  IF error=0 THEN error:=FSRead(StartDummy,y,@NewBits);
			  IF IOCheck(error) THEN
				BEGIN
				  error:=FSClose(StartDummy);
				  JunkFlag:=IOCheck(error);
				END
			  ELSE x:=StopAlert(336,NIL);
			END
		  ELSE x:=StopAlert(336,NIL);
		END;
	END;
  IF SoundOn THEN SetItem(MenuArr[3],1,'Turn Sound Off')
			 ELSE SetItem(MenuArr[3],1,'Turn Sound On');
  IF NarratOn THEN SetItem(MenuArr[3],2,'Turn Narration Off')
			 ELSE SetItem(MenuArr[3],2,'Turn Narration On');
  FOR i:=1 TO 3 DO CheckItem(MenuArr[3],2+i,FALSE);
  IF StoryDelay=ExpDelay THEN x:=5;
  IF StoryDelay=IntDelay THEN x:=4;
  IF StoryDelay=BegDelay THEN x:=3;
  CheckItem(MenuArr[3],x,TRUE);

  CopyBits(NewBMap,Screenbits,NewRect,NewRect,srcCopy,NIL);
  DrawMenuBar;
  {CleanOutRect(PlayRect);
  PlotSntc(Player,ScrnX2+6,ScrnY1+16,(SntcIndx<>ObjectB2));
  NewWordSet(TRUE);
  StatDisp;
  CleanOutRect(RoomRect);}
END;
{********************************************************************************}
PROCEDURE LoadGame;
VAR
  LoclRect:		Rect;
  LoclBits:		ARRAY[1..6000] OF Integer;
  LoclBMap:		BitMap;
  JunkFlag:		Boolean;
  error:		OSErr;
  DummyF1:		Integer;
  i,x:			Integer;
  y:			LongInt;
  DumPoint:		Point;
  DumStrng:	 	Str255;
  MyTypeList:	SFTypeList;
  MyReply:		SFReply;
BEGIN
  SetRect(LoclRect,80,90,464,340);
  LoclBMap.rowBytes:=48;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  DumPoint.h:=100; DumPoint.v:=100;
  DumStrng:='Saved Game Name:';
  MyTypeList[0]:='SBTF';
  SFGetFile(DumPoint,DumStrng,NIL,1,MyTypeList,NIL,MyReply);
  SetPort(@MyPort);
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
  IF MyReply.good THEN OpenGame(MyReply.fName,myReply.VRefNum);
END;
{********************************************************************************}
PROCEDURE SaveGame;
VAR
  error:		OSErr;
  i,x:			Integer;
  y:			LongInt;
  DumPoint:		Point;
  DumStrng,PStrng:	 Str255;
  MyTypeList:	SFTypeList;
  MyReply:		SFReply;
  RetryFlag:	Boolean;
  LoclRect:		Rect;
  LoclBits:		ARRAY[1..10944] OF Integer;
  LoclBMap:		BitMap;
  theInfo:		FInfo;
  ResultCode:	OSErr;
  GoodFlag:	Boolean;
BEGIN
  SetRect(LoclRect,0,0,512,342);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  HideCursor;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  ShowCursor;
  DumPoint.h:=100; DumPoint.v:=100;
  DumStrng:='Save Game As:'; PStrng:='SavedGame';
  MyTypeList[1]:='SBTF';
  REPEAT
    RetryFlag:=TRUE;
	GoodFlag:=TRUE;
    SFPutFile(DumPoint,DumStrng,PStrng,NIL,MyReply);
  	SetPort(@MyPort);
    CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
    IF MyReply.good THEN
      BEGIN
	    ResultCode:=GetFInfo(MyReply.fName,myReply.VRefNum,theInfo);
		CASE ResultCode OF
		  NoErr: IF theInfo.fdType<>'SBTF' THEN GoodFlag:=IOCheck(337);
		  FNFErr:
		    BEGIN
			  error:=Create(myReply.fName,myReply.VRefNum,'SIBT','SBTF');
			  GoodFlag:=IOCheck(error);
			END;
		  Otherwise GoodFlag:=IOCheck(ResultCode);
		  END; {of CASE-statement}
        IF GoodFlag THEN
          BEGIN
            error:=FSOpen(MyReply.fName,myReply.VRefNum,StartDummy);
            IF IOCheck(error) THEN
              BEGIN
                y:=LongInt(@StartDummy)-LongInt(@EndDummy);
                error:=FSWrite(StartDummy,y,@EndDummy);
				y:=LongInt(2*HistLeng);
				IF error=0 THEN error:=FSWrite(StartDummy,y,@HstWrd1H^^);
				IF error=0 THEN error:=FSWrite(StartDummy,y,@HstWrd3H^^);
				IF error=0 THEN error:=FSWrite(StartDummy,y,@HstDateH^^);
				IF error=0 THEN error:=FSWrite(StartDummy,y,@HstTimeH^^);
				y:=21888;
				IF error=0 THEN error:=FSWrite(StartDummy,y,LoclBMap.baseaddr);
				IF IOCheck(error) THEN
                  BEGIN
					error:=FSClose(StartDummy);
					IF IOCheck(error) THEN
					  BEGIN
						error:=FlushVol(NIL,0);
						IF IOCheck(error) THEN RetryFlag:=FALSE;
                      END
					ELSE error:=FSDelete(MyReply.fName,myReply.VRefNum);
                  END;
              END;
          END;
        CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
      END
	ELSE RetryFlag:=FALSE;
  UNTIL NOT RetryFlag;
  SetPort(@MyPort);
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
END;
{********************************************************************************}
PROCEDURE ChangeDelay(DelayLevel: Integer);
VAR
  x:	Integer;
BEGIN
 IF StoryDelay=ExpDelay THEN x:=5;
 IF StoryDelay=IntDelay THEN x:=4;
 IF StoryDelay=BegDelay THEN x:=3;
 IF DelayLevel=3 THEN StoryDelay:=BegDelay;
 IF DelayLevel=4 THEN StoryDelay:=IntDelay;
 IF DelayLevel=5 THEN StoryDelay:=ExpDelay; 
 CheckItem(MenuArr[3],x,FALSE);
 CheckItem(MenuArr[3],DelayLevel,TRUE);
END;
{********************************************************************************}
FUNCTION HitRect(TempRect:Rect): Boolean;
BEGIN
  HitRect:=FALSE;
  IF PtInRect(MousePt,TempRect) THEN
    BEGIN
	  InvertRect(TempRect);
	  REPEAT UNTIL NOT StillDown;
	  InvertRect(TempRect);
	  GetMouse(MousePt);
	  IF PtInRect(MousePt,TempRect) THEN HitRect:=TRUE;
    END;
END;
{********************************************************************************}
{$IFC DebugFlg}
PROCEDURE DumpChars;
CONST
  LoclX = 0;
  LoclY = 80;
VAR
  i,j,x:	Integer;
  LoclRect:		 Rect;
  LoclBits:		 ARRAY[1..7296] OF Integer;
  LoclBMap:		 BitMap;
BEGIN
  SetRect(LoclRect,LoclX,LoclY,512,308);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  FillRect(LoclRect,white);
  FrameRect(LoclRect);
  TextFont(1); TextSize(9);
  MoveTo(2,LoclY+20); DrawString('Name');
  MoveTo(2,LoclY+34); DrawString('Sntc1');
  MoveTo(2,LoclY+48); DrawString('Sntc2');
  MoveTo(2,LoclY+62); DrawString('Locn');
  MoveTo(2,LoclY+76); DrawString('Last');
  MoveTo(2,LoclY+90); DrawString('Sntc');
  MoveTo(2,LoclY+104); DrawString('Exec');
  MoveTo(2,LoclY+118); DrawString('Interloc');
  MoveTo(2,LoclY+132); DrawString('Door');
  MoveTo(2,LoclY+146); DrawString('Dlog');
  MoveTo(2,LoclY+160); DrawString('Hist');
  MoveTo(2,LoclY+174); DrawString('Dbg1');
  MoveTo(2,LoclY+188); DrawString('Dbg2');
  MoveTo(2,LoclY+202); DrawString('Dbg3');
  MoveTo(2,LoclY+216); DrawString('Dbg4');
  FOR i:=1 TO NumChars DO 
    BEGIN
	  x:=LoclX+14+64*(i-1)+30;
	  MoveTo(x,LoclY+20);
	  DrawString(CharName[i]);
	  MoveTo(x,LoclY+34);
	  FOR j:=1 TO 4 DO 
	    BEGIN MyWrite(Sentence[i,j]); DrawString(' '); END;
	  MoveTo(x,LoclY+48);
	  FOR j:=5 TO 8 DO 
	    BEGIN MyWrite(Sentence[i,j]); DrawString(' '); END;
      MoveTo(x,LoclY+62);
	  MyWrite(CharLocn[i]);
	  MoveTo(x,LoclY+76);
	  FOR j:=1 TO 4 DO 
	    BEGIN MyWrite(LastSntc[i,j]); DrawString(' '); END;
	  MoveTo(x,LoclY+90);
	  FOR j:=5 TO 8 DO 
	    BEGIN MyWrite(LastSntc[i,j]); DrawString(' '); END;
	  MoveTo(x,LoclY+104);
	  MyWrite(ExecTime[i]);
	  MoveTo(x,LoclY+118);
	  MyWrite(Interloc[i]);
	  MoveTo(x,LoclY+132);
	  IF DoorLock[i] THEN DrawString('Locked') ELSE DrawString('Open');
	  MoveTo(x,LoclY+146);
	  FOR j:=1 TO 4 DO 
	    BEGIN MyWrite(DlogHist[i,j,2]); DrawString(' '); END;
	  MoveTo(x,LoclY+160);
	  FOR j:=5 TO 8 DO 
	    BEGIN MyWrite(DlogHist[i,j,2]); DrawString(' '); END;
	  MoveTo(x,LoclY+174);
	  MyWrite(Debug1[i]);
	  MoveTo(x,LoclY+188);
	  MyWrite(Debug2[i]);
	  MoveTo(x,LoclY+202);
	  MyWrite(Debug3[i]);
	  MoveTo(x,LoclY+216);
	  MyWrite(Debug4[i]);
	END;
  MoveTo(x,LoclY+230); MyWrite(Time);
  REPEAT UNTIL Button;
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
  TextFont(0); TextSize(12);
END;
{$ENDC}
{********************************************************************************}
{$IFC DebugFlg}
PROCEDURE DumpMatrix;
CONST
  LoclX = 0;
  LoclY = 80;
VAR
  i,j,x:	Integer;
  LoclRect:		 Rect;
  LoclBits:		 ARRAY[1..7296] OF Integer;
  LoclBMap:		 BitMap;
BEGIN
  SetRect(LoclRect,LoclX,LoclY,512,308);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  FillRect(LoclRect,white);
  FrameRect(LoclRect);
  TextFont(1); TextSize(9);
  FOR i:=1 TO NumChars DO 
    BEGIN
	  MoveTo(2,LoclY+28*i+20);
	  DrawString(CharName[i]);
	  x:=LoclX+14+67*(i-1)+30;
	  MoveTo(x,LoclY+20);
	  DrawString(CharName[i]);
	  MoveTo(x,LoclY+34);
	  FOR j:=1 TO NumChars DO
	    BEGIN
		  MoveTo(x,LoclY+28*j+20);
		  MyWrite(Fear[j,i]);
		  DrawString(':');
		  MyWrite(Trust[j,i]);
		  DrawString(':');
		  MyWrite(Love[j,i]);
		END;
	END;
  REPEAT UNTIL Button;
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
  TextFont(0); TextSize(12);
END;
{$ENDC}
{********************************************************************************}
{$IFC DebugFlg}
PROCEDURE DumpVals;
CONST
  LoclX = 0;
  LoclY = 80;
VAR
  i,j,x:	Integer;
  LoclRect:		 Rect;
  LoclBits:		 ARRAY[1..7296] OF Integer;
  LoclBMap:		 BitMap;
BEGIN
  SetRect(LoclRect,LoclX,LoclY,512,308);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  FillRect(LoclRect,white);
  FrameRect(LoclRect);
  TextFont(1); TextSize(9);
  FOR i:=1 TO 16 DO 
    BEGIN
	  FOR j:=1 TO 8 DO
	    BEGIN
		  MoveTo(48*j,LoclY+14*i);
		  MyWrite(DebugVal[8*(i-1)+j]);
		END;
	END;
  REPEAT SystemTask; UNTIL Button;
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
  TextFont(0); TextSize(12);
END;
{$ENDC}
{********************************************************************************}
{$IFC DebugFlg}
PROCEDURE DumpDeals;
CONST
  LoclX = 0;
  LoclY = 80;
VAR
  i,j,x,BaseX,BaseY:	Integer;
  LoclRect:		 Rect;
  LoclBits:		 ARRAY[1..7296] OF Integer;
  LoclBMap:		 BitMap;
BEGIN
  SetRect(LoclRect,LoclX,LoclY,512,308);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  FillRect(LoclRect,white);
  FrameRect(LoclRect);
  TextFont(1); TextSize(9);
  {FOR i:=1 TO 16 DO IF i<=DealCount THEN
    BEGIN
	  MoveTo(48,LoclY+14*i);
	  MyWrite(DealTemp[i]);
	  MoveTo(96,LoclY+14*i);
	  MyWrite(DealDesp[i]);
	  MoveTo(144,LoclY+14*i);
	  MyWrite(DealOblg[i]);
	  MoveTo(192,LoclY+14*i);
	  MyWrite(DealTrst[i]);
	  MoveTo(240,LoclY+14*i);
	  MyWrite(DealTrMd[i]);
	  MoveTo(288,LoclY+14*i);
	  MyWrite(DealLove[i]);
	END;}
  BaseX:=0;
  FOR i:=1 TO HistIndx DO
    BEGIN
	  IF ((i mod 16)=0) THEN BaseX:=BaseX+120;
	  BaseY:=14*(i mod 16)+14;
	  MoveTo(BaseX+20,LoclY+BaseY); MyWrite(HstWrd1H^^[i]);
	  MoveTo(BaseX+40,LoclY+BaseY); MyWrite(HstWrd3H^^[i]);
	  MoveTo(BaseX+60,LoclY+BaseY); MyWrite(HstDateH^^[i]);
	  MoveTo(BaseX+80,LoclY+BaseY);
	  FOR j:=1 TO 8 DO IF HstKnowH[i,j] THEN DrawString('T') ELSE DrawString('F');
	END;  
  REPEAT SystemTask; UNTIL Button;
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
  TextFont(0); TextSize(12);
END;
{$ENDC}
{********************************************************************************}
{$IFC DebugFlg}
PROCEDURE DumpDlog;
CONST
  LoclX = 0;
  LoclY = 80;
VAR
  i,j,x,y,z:	Integer;
  LoclRect:		Rect;
  LoclBits:		ARRAY[1..7296] OF Integer;
  LoclBMap:		BitMap;
BEGIN
  SetRect(LoclRect,LoclX,LoclY,512,308);
  LoclBMap.rowBytes:=64;
  LoclBMap.baseAddr:=@LoclBits;
  LoclBMap.bounds:=LoclRect;
  CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
  FillRect(LoclRect,white);
  FrameRect(LoclRect);
  TextFont(1); TextSize(9);
  x:=DlogIndx[Player];
  z:=Interloc[Player];
  IF z>0 THEN
    BEGIN
  	  y:=DlogIndx[z];
	  FOR i:=x-15 TO x DO IF i>0  THEN
		BEGIN
		  FOR j:=1 TO SntcLeng DO
		    BEGIN
		  	  MoveTo(24*j,LoclY+14*(i-x+16));
		  	  MyWrite(DlogHist[Player,i,j]);
		  	  MoveTo(240+24*j,LoclY+14*(i-y+16));
		  	  MyWrite(DlogHist[z,i,j]);
			END;
		END;
	END;
  REPEAT SystemTask; UNTIL Button;
  CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
  TextFont(0); TextSize(12);
END;
{$ENDC}
{********************************************************************************}
PROCEDURE DoCommand;
CONST
  AppleMen  = 1;
  GameMen   = 2;
  OptionMen = 3;
  CharMen   = 4;
  RecallMen = 5;
  DebugMen  = 6;
  QuitItem  = 1;
VAR
  theMenu,theItem,i,j,k,x,y,refNum:     Integer;
  name:			 Str255;
  TempRect:		 Rect;
  LoclRect:		 Rect;
  LoclBits:		 ARRAY[1..3696] OF Integer;
  LoclBMap:		 BitMap;
  JunkFlag:		 Boolean;
  mySWPtr:     SWSynthPtr;
  TestPtr:     Ptr;
  TestHndl:    Handle;
  SinTab:      DumbArray;
  BitMask:     DtArray;
  TestRect:    Rect;
  ShimMap:     BitMap;
  ShimBits:    IditArr;
  DelayT:      LongInt;
BEGIN
  theMenu:=HiWord(mResult); theItem:=LoWord(mResult);
  CASE theMenu OF
    AppleMen: DoAboutSiboot;
    GameMen:
      BEGIN
		IF theItem=1 THEN LoadGame;
		IF theItem=2 THEN SaveGame;
	    IF theItem=3 THEN
		  BEGIN
			SetRect(LoclRect,80,90,464,244);
			LoclBMap.rowBytes:=48;
			LoclBMap.baseAddr:=@LoclBits;
			LoclBMap.bounds:=LoclRect;
			CopyBits(Screenbits,LoclBMap,LoclRect,LoclRect,srcCopy,NIL);
			x:=CautionAlert(137,NIL);
			CopyBits(LoclBMap,ScreenBits,LoclRect,LoclRect,srcCopy,NIL);
			QuitFlag:=(x=2);
		  END;
      END;
    OptionMen:
      BEGIN
	    CASE theItem OF
          1: BEGIN
              SoundOn:=NOT SoundOn;
              IF SoundOn THEN SetItem(MenuArr[3],1,'Turn Sound Off')
                         ELSE SetItem(MenuArr[3],1,'Turn Sound On');
             END;
		  2: BEGIN
		      NarratOn:=NOT NarratOn;
              IF NarratOn THEN SetItem(MenuArr[3],2,'Turn Narration Off')
                          ELSE SetItem(MenuArr[3],2,'Turn Narration On');
             END;
		  3,4,5: ChangeDelay(theItem);
		END;
      END;
    CharMen:  IF theItem=1 THEN CharDisp ELSE Dossier(theItem-1);
	RecallMen: RecallToday;
		
    {$IFC DebugFlg}
    DebugMen:
      BEGIN
        CASE theItem OF
          1: EditWords;
          2: BEGIN {Write version number}
               MoveTo(ScrnX2,340);
               DrawString('Compiled on ');
               DrawString(CompDate); DrawString(' at ');
               DrawString(CompTime);
             END;
          3: BEGIN
               EnableItem(MenuArr[5],Player);
               Player:=Player+1;
               IF Player>NumChars THEN Player:=1;
               CleanOutRect(RoomRect);
             END;
		  4: DumpChars;
		  5: {DumpMatrix;} DumpDlog;
		  6: DumpVals;
		  7: DumpDeals;
		END; {of inner CASE-statement}
      END;
    {$ENDC}
  END; {of CASE statement}
  HiLiteMenu(0);
END;
{********************************************************************************}
END.